<?php
/*
Plugin Name: FlipBook Passaportes
Description: Plugin para criação de FlipBook personalizado
Author: Empório High Tech
Version: 1.0
*/


define('FLIP_DIR', plugin_dir_path( __FILE__ ) );
define('FlIP_DIR_URL', plugin_dir_url( __FILE__ ));

require_once(FLIP_DIR . 'flipbook.php');
require_once(FLIP_DIR . 'meta_box/add_order_passaporte.php');
require_once(FLIP_DIR . 'settingsShortcode.php');

add_action( 'admin_enqueue_scripts', 'flipbookpass_enqueue_scripts' );
if (!function_exists('flipbookpass_enqueue_scripts'))
{
    function flipbookpass_enqueue_scripts($hook)
	{
		wp_enqueue_script('salva-ordem-pass-js', plugins_url('js/salva_ordem_pass.js', __FILE__), array('jquery'), false, true);

        wp_enqueue_script('sweetalert2-js', plugins_url('includes/sweetalert2/sweetalert2.js', __FILE__), array('jquery'), false, true);
        wp_enqueue_style('sweetalert2-css', plugins_url('includes/sweetalert2/sweetalert2.css', __FILE__));
	}

}

add_action( 'wp_enqueue_scripts', 'flipbookpass_enqueue_scripts_site' );
if (!function_exists('flipbookpass_enqueue_scripts_site'))
{
    function flipbookpass_enqueue_scripts_site($hook)
	{
        wp_enqueue_script('wow-book-js', plugins_url('includes/wow_book/wow_book.min.js', __FILE__), array('jquery'), false, true);
        wp_enqueue_style('wow-book-css', plugins_url('includes/wow_book/wow_book.css', __FILE__));

        wp_enqueue_style('conf-flipbook-css', plugins_url('css/cont_flipbook.css', __FILE__));
	}

}


